<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Parent theme: boost
 *
 * @package   theme_edmo
 * @copyright EnvyTheme
 *
 */

// Protects the file from being accessed by a URL directly.
defined('MOODLE_INTERNAL') || die();

// This is used for performance, we don't need to know about these settings on every page in Moodle, only when
// we are looking at the admin settings pages.
if ($ADMIN->fulltree) {

    // Boost provides a nice setting page which splits settings onto separate tabs. We want to use it here.
    $settings = new theme_boost_admin_settingspage_tabs('themesettingedmo', get_string('configtitle', 'theme_edmo'));

    /*
    * ----------------------
    * General setting
    * ----------------------
    */
    $page = new admin_settingpage('theme_edmo_general', get_string('generalsettings', 'theme_edmo'));

    // Logo file setting.
    $name = 'theme_edmo/logo';
    $title = get_string('logo', 'theme_edmo');
    $description = get_string('logodesc', 'theme_edmo');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'logo');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Navbar Search Placeholder Title.
    $name = 'theme_edmo/search_placeholder';
    $title = get_string('search_placeholder', 'theme_edmo');
    $default = 'Search for anything';
    $description = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Preset files setting.
    $name = 'theme_edmo/preset';
    $title = get_string('preset', 'theme_edmo');
    $description = get_string('preset_desc', 'theme_edmo');
    $default = 'default.scss';

    $context = context_system::instance();
    $fs = get_file_storage();
    $files = $fs->get_area_files($context->id, 'theme_edmo', 'preset', 0, 'itemid, filepath, filename', false);

    $choices = [];
    foreach ($files as $file) {
        $choices[$file->get_filename()] = $file->get_filename();
    }
    // These are the built in presets from Boost.
    $choices['default.scss'] = 'default.scss';
    $choices['plain.scss'] = 'plain.scss';

    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Preset files setting.
    $name = 'theme_edmo/presetfiles';
    $title = get_string('presetfiles','theme_edmo');
    $description = get_string('presetfiles_desc', 'theme_edmo');

    $setting = new admin_setting_configstoredfile($name, $title, $description, 'preset', 0,
        array('maxfiles' => 20, 'accepted_types' => array('.scss')));
    $page->add($setting);

    // Variable $brand-color.
    // We use an empty default value because the default colour should come from the preset.
    $name = 'theme_edmo/brandcolor';
    $title = get_string('brandcolor', 'theme_edmo');
    $description = get_string('brandcolor_desc', 'theme_edmo');
    $setting = new admin_setting_configcolourpicker($name, $title, $description, '');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Must add the page after definiting all the settings!
    $settings->add($page);

    /*
    * ----------------------
    * Advanced settings tab
    * ----------------------
    */
    $page = new admin_settingpage('theme_edmo_advanced', get_string('advancedsettings', 'theme_edmo'));

    // Raw SCSS to include before the content.
    $setting = new admin_setting_configtextarea('theme_edmo/scsspre',
        get_string('rawscsspre', 'theme_edmo'), get_string('rawscsspre_desc', 'theme_edmo'), '', PARAM_RAW);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Raw SCSS to include after the content.
    $setting = new admin_setting_configtextarea('theme_edmo/scss', get_string('rawscss', 'theme_edmo'), get_string('rawscss_desc', 'theme_edmo'), '', PARAM_RAW);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    $settings->add($page);

    /*
    * --------------------
    * Footer settings tab
    * --------------------
    */
    $page = new admin_settingpage('theme_edmo_footer', get_string('footersettings', 'theme_edmo'));

    // Footer Logo file setting.
    $name = 'theme_edmo/footer_logo';
    $title = get_string('footer_logo', 'theme_edmo');
    $description = get_string('footerlogodesc', 'theme_edmo');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'footer_logo');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Description
    $name = 'theme_edmo/footer_desc';
    $title = get_string('footer_desc', 'theme_edmo');
    $default = 'Working to bring significant changes in online-based learning by doing extensive research for course curriculum preparation, student engagements, and looking forward to the flexible education!';
    $description = '';
    $setting = new admin_setting_configtextarea ($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Facebook url setting.
    $name = 'theme_edmo/facebook';
    $title = get_string('facebook', 'theme_edmo');
    $description = get_string('facebookdesc', 'theme_edmo');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Twitter url setting.
    $name = 'theme_edmo/twitter';
    $title = get_string('twitter', 'theme_edmo');
    $description = get_string('twitterdesc', 'theme_edmo');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Linkdin url setting.
    $name = 'theme_edmo/linkedin';
    $title = get_string('linkedin', 'theme_edmo');
    $description = get_string('linkedindesc', 'theme_edmo');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Youtube url setting.
    $name = 'theme_edmo/youtube';
    $title = get_string('youtube', 'theme_edmo');
    $description = get_string('youtubedesc', 'theme_edmo');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Instagram url setting.
    $name = 'theme_edmo/instagram';
    $title = get_string('instagram', 'theme_edmo');
    $description = get_string('instagramdesc', 'theme_edmo');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Whatsapp url setting.
    $name = 'theme_edmo/whatsapp';
    $title = get_string('whatsapp', 'theme_edmo');
    $description = get_string('whatsappdesc', 'theme_edmo');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Info Title One
    $name = 'theme_edmo/footer_info1';
    $title = get_string('footer_info1', 'theme_edmo');
    $description = '';
    $default = 'Explore';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Info Description One
    $name = 'theme_edmo/footer_info1_desc';
    $title = get_string('footer_info1_desc', 'theme_edmo');
    $default = '<li><a href="#">Home</a></li>';
    $description = '';
    $setting = new admin_setting_configtextarea ($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Info Title Two
    $name = 'theme_edmo/footer_info2';
    $title = get_string('footer_info2', 'theme_edmo');
    $description = '';
    $default = 'Resources';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Info Description Two
    $name = 'theme_edmo/footer_info2_desc';
    $title = get_string('footer_info2_desc', 'theme_edmo');
    $default = '<li><a href="#">Home</a></li>';
    $description = '';
    $setting = new admin_setting_configtextarea ($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Info Title Three
    $name = 'theme_edmo/footer_info3';
    $title = get_string('footer_info3', 'theme_edmo');
    $description = '';
    $default = 'Address';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Info Description Three
    $name = 'theme_edmo/footer_info3_desc';
    $title = get_string('footer_info3_desc', 'theme_edmo');
    $default = '<li><i class="bx bx-map"></i>2750 Quadra Street Golden Victoria Road, New York, USA</li>';
    $description = '';
    $setting = new admin_setting_configtextarea ($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Copyright Text
    $name = 'theme_edmo/footer_copyright';
    $title = get_string('footer_copyright', 'theme_edmo');
    $default = '<i class="bx bx-copyright"></i>2020 Edmo is Proudly Powered by <a target="_blank" href="https://envytheme.com/">EnvyTheme</a>';
    $description = '';
    $setting = new admin_setting_configtextarea ($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Footer Copyright Menu
    $name = 'theme_edmo/footer_menu';
    $title = get_string('footer_menu', 'theme_edmo');
    $default = '<li><a href="#">Privacy Policy</a></li>';
    $description = '';
    $setting = new admin_setting_configtextarea ($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    $settings->add($page);

}